﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using InfoWorld.HL7.ITS;
using BMS.Web.Controllers.Shared;

namespace BMS.Web.Models
{
    public class AdminCommentsViewModel : BaseViewModel
    {
        /// <summary>
        /// Gets or sets the comment value.
        /// </summary>
        /// <value>
        /// The comment value.
        /// </value>
        [ValidateXss]
        public string CommentValue { get; set; }

        /// <summary>
        /// Gets or sets the standardized comment list.
        /// </summary>
        /// <value>
        /// The standardized comment list.
        /// </value>
        public IList<CD> StandardizedCommentList { get; set; }

        /// <summary>
        /// Gets or sets the last concept code.
        /// </summary>
        /// <value>
        /// The last concept code.
        /// </value>
        public int LastConceptCode { get; set; }

        /// <summary>
        /// Gets or sets the display message action.
        /// </summary>
        /// <value>
        /// The display message action.
        /// </value>
        public string DisplayMessageAction { get; set; }

        /// <summary>
        /// Gets or sets the selected concept code.
        /// </summary>
        /// <value>
        /// The selected concept code.
        /// </value>
        public string SelectedConceptCode { get; set; }
    }
}